/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.dialog.SelectDefaultEditorPanel;
import DE.siemens.ad.logo.dialog.comp.ExtendedTreeSelectionModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OptionsPanel
extends DataInputPanel
implements ExtendedTreeSelectionModel.ExtendedTreeSelectionListener {
    private List fPanelsWithLoadedData = new ArrayList(10);
    protected JSplitPane fSplitPane;
    protected JTree fPanelTree;
    protected JPanel fPanelView;
    protected JPanel fDataInputPanelContainer;
    protected JLabel fTitleLabel;
    protected Hashtable fPanelTreeNodeDictionary;
    protected DefaultTreeModel fTreeModel;
    protected JPanel fTitlePanel;

    public OptionsPanel() {
        this.initComponents();
        if (Application.getInstance().getEditorInfos().size() > 1) {
            SelectDefaultEditorPanel sdep = new SelectDefaultEditorPanel();
            this.addPanel(sdep);
        }
    }

    public boolean addPanel(DataInputPanel dataInputPanel) {
        if (this.fPanelTreeNodeDictionary.containsKey(dataInputPanel)) {
            return false;
        }
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(dataInputPanel);
        ((DefaultMutableTreeNode)this.fTreeModel.getRoot()).add(dmtn);
        this.fPanelTreeNodeDictionary.put(dataInputPanel, dmtn);
        return true;
    }

    public boolean addPanel(DataInputPanel newDataInputPanel, DataInputPanel parent) {
        if (this.fPanelTreeNodeDictionary.containsKey(newDataInputPanel)) {
            return false;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.fPanelTreeNodeDictionary.get(parent);
        if (parentNode == null) {
            return false;
        }
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(newDataInputPanel);
        parentNode.add(dmtn);
        this.fPanelTreeNodeDictionary.put(newDataInputPanel, dmtn);
        return true;
    }

    public boolean checkChanged() {
        Iterator i = this.fPanelTreeNodeDictionary.keySet().iterator();
        DataInputPanel dataInputPanel = null;
        while (i.hasNext()) {
            dataInputPanel = (DataInputPanel)i.next();
            if (!dataInputPanel.checkChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean checkFieldContents() {
        Iterator i = this.fPanelTreeNodeDictionary.keySet().iterator();
        DataInputPanel dataInputPanel = null;
        while (i.hasNext()) {
            dataInputPanel = (DataInputPanel)i.next();
            if (dataInputPanel.checkFieldContents()) continue;
            return false;
        }
        return true;
    }

    protected DataInputPanel getDataInputPanel() {
        DefaultMutableTreeNode newSelectedNode = (DefaultMutableTreeNode)this.fPanelTree.getSelectionPath().getLastPathComponent();
        return (DataInputPanel)newSelectedNode.getUserObject();
    }

    public String getBoundsID() {
        return "dialog.Options";
    }

    public String getHelpIdString() {
        return this.getDataInputPanel().getHelpIdString();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 350);
    }

    public String getTitle() {
        return Language.getString("dialog.options.title", "Options");
    }

    private void initComponents() {
        this.fPanelTreeNodeDictionary = new Hashtable();
        this.fTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Options"));
        this.fPanelTree = new JTree(this.fTreeModel);
        this.fPanelTree.expandPath(new TreePath(this.fTreeModel.getRoot()));
        this.fPanelView = new JPanel(new BorderLayout());
        this.fTitlePanel = new JPanel(new FlowLayout(1));
        this.fTitlePanel.setBackground(this.fTitlePanel.getBackground().darker());
        this.fTitleLabel = new JLabel();
        this.fTitleLabel.setFont(new Font("Dialog", 1, 14));
        this.fTitlePanel.add(this.fTitleLabel);
        this.fPanelView.add((Component)this.fTitlePanel, "North");
        this.fDataInputPanelContainer = new JPanel(new BorderLayout());
        this.fDataInputPanelContainer.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.fPanelView.add((Component)new JScrollPane(this.fDataInputPanelContainer), "Center");
        this.fSplitPane = new JSplitPane(1, new JScrollPane(this.fPanelTree), this.fPanelView);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fSplitPane, "Center");
        ExtendedTreeSelectionModel etsm = new ExtendedTreeSelectionModel();
        etsm.setSelectionMode(1);
        etsm.addTreeSelectionListener(this);
        this.fPanelTree.setSelectionModel(etsm);
        this.fPanelTree.setCellRenderer(new TitleTreeCellRenderer());
    }

    public void loadFieldContents() throws ProgramException {
        this.fPanelTree.expandPath(new TreePath(this.fTreeModel.getRoot()));
        this.fPanelTree.setRootVisible(false);
        this.fPanelTree.setShowsRootHandles(false);
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.fTreeModel.getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            this.fPanelTree.setSelectionPath(new TreePath(node.getPath()));
            break;
        }
    }

    public void selectionWillChange(TreeSelectionEvent tse) {
    }

    public void setLabels() {
        Iterator i = this.fPanelTreeNodeDictionary.keySet().iterator();
        while (i.hasNext()) {
            ((DataInputPanel)i.next()).setLabels();
        }
    }

    public void storeFieldContents() {
        Iterator i = this.fPanelsWithLoadedData.iterator();
        DataInputPanel dataInputPanel = null;
        while (i.hasNext()) {
            dataInputPanel = (DataInputPanel)i.next();
            if (!dataInputPanel.checkChanged()) continue;
            dataInputPanel.storeFieldContents();
        }
    }

    public void valueChanged(TreeSelectionEvent tse) {
        if (tse.getNewLeadSelectionPath() == null) {
            return;
        }
        DataInputPanel dataInputPanel = this.getDataInputPanel();
        if (!this.fPanelsWithLoadedData.contains(dataInputPanel)) {
            try {
                dataInputPanel.loadFieldContents();
                this.fPanelsWithLoadedData.add(dataInputPanel);
            }
            catch (Throwable e) {
                System.out.println("Exception during loading of Data for Panel " + dataInputPanel.toString() + "\n" + e.getStackTrace());
                JOptionPane.showMessageDialog(this, "Error while loading panel data.\n" + e, "Error", 0);
                return;
            }
        }
        this.fTitleLabel.setText(dataInputPanel.getTitle());
        this.fDataInputPanelContainer.removeAll();
        this.fDataInputPanelContainer.add(dataInputPanel);
        this.fPanelView.validate();
        this.fPanelView.repaint();
    }

    private class TitleTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon fEmptyIcon = Global.getIcon("Empty.gif");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof DataInputPanel) {
                DataInputPanel dataInputPanel = (DataInputPanel)node.getUserObject();
                this.setText(dataInputPanel.getTitle());
                Icon icon = dataInputPanel.getIcon();
                if (icon != null) {
                    this.setIcon(dataInputPanel.getIcon());
                } else {
                    this.setIcon(this.fEmptyIcon);
                }
            }
            return this;
        }
    }
}

